//
//  NSDataToInteger.h
//  Tests
//
//  Created by Georg Seifert on 2.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
uint16_t F2DOT14(CGFloat Float );
inline NSString * num2binary(NSInteger l, short bits) ;
inline NSInteger binary2num(NSString * bin) ;

@interface NSData (DataToInteger)

- (u_int8_t) unsignedInt8AtOffset:(NSUInteger*)offsetPtr ;
- (int8_t) int8AtOffset:(NSUInteger*)offsetPtr ;

- (int16_t) int16AtOffset:(NSUInteger*)offsetPtr ;
- (u_int16_t) unsignedInt16AtOffset:(NSUInteger*)offsetPtr ;

- (int32_t) int32AtOffset:(NSUInteger*)offsetPtr ;
- (u_int32_t) unsignedInt32AtOffset:(NSUInteger*)offsetPtr ;

- (NSUInteger) unsignedIntegerAtOffset:(NSUInteger*)offsetPtr ofSize: (NSUInteger)size;
- (NSInteger) signedIntegerAtOffset:(NSUInteger*)offsetPtr ofSize: (NSUInteger)size;

- (NSData*) subdataFromIndex:(NSUInteger) aIndex;
@end
